  /*
   *  Object %CRYS_RSA_PRIME.c    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:25:55 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief this module contains the routines used to create the public and private keys
   *         database and routines to check the validity of the private and public keys database. 
   *
   *  \version CRYS_RSA_BUILD.c#1:csrc:6
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/

#include "DX_VOS_Mem.h"
#include "CRYS.h"
#include "CRYS_RSA_error.h"
#include "PLAT_SystemDep.h"
#include "dx_hw_defs.h"
#include "crys_host_op_code.h"

/************************ Defines ******************************/

/* canceling the lint warning:
   Use of goto is deprecated */
/*lint --e{801} */

/************************ Enums ******************************/


/************************ Typedefs ******************************/


/************************ Global Data ******************************/

/************************ Public Functions ******************************/

#if !defined(_INTERNAL_CRYS_NO_RSA_ENCRYPT_SUPPORT) && !defined(_INTERNALCRYS_NO_RSA_VERIFY_SUPPORT)
/**
@brief
CRYS_RSA_PRIM_Encrypt implements the RSAEP algorithm as defined in PKCS#1 v2.1 6.1.1

  @param[in] UserPubKey_ptr - Pointer to the public key data structure.
  @param[in] PrimeData_ptr - a pointer to a structure containing internal buffers
  @param[in] Data_ptr - Pointer to the data to encrypt.
  @param[in] DataSize - The size, in bytes, of the data to
                        encrypt. \note Must be <= the size of the
                        modulus.
  @param[out] Output_ptr - Pointer to the encrypted data, the buffer
                           must be at least PubKey_ptr->N.len bytes
                           long (that is, the size of the modulus, in
                           bytes).

  @return CRYSError_t - CRYS_OK,
                        CRYS_RSA_INVALID_PUB_KEY_STRUCT_POINTER_ERROR,
                        CRYS_RSA_PUB_KEY_VALIDATION_TAG_ERROR,
                        CRYS_RSA_PRIM_DATA_STRUCT_POINTER_INVALID,
                        CRYS_RSA_DATA_POINTER_INVALID_ERROR,
                        CRYS_RSA_INVALID_OUTPUT_POINTER_ERROR,
                        CRYS_RSA_INVALID_MESSAGE_BUFFER_SIZE,
                        CRYS_RSA_INVALID_MESSAGE_DATA_SIZE,
                        CRYS_RSA_INVALID_MESSAGE_VAL
 */
CEXPORT_C CRYSError_t CRYS_RSA_PRIM_Encrypt(CRYS_RSAUserPubKey_t *UserPubKey_ptr,
                                  CRYS_RSAPrimeData_t  *PrimeData_ptr,
                                  DxUint8_t              *Data_ptr,
                                  DxUint16_t              DataSize,
                                  DxUint8_t              *Output_ptr)
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PRIM_ENC_OP_CODE, 5,
	   							 /* PARAMETERS: */
								 UserPubKey_ptr,
								 PrimeData_ptr,
								 Data_ptr, DataSize,
								 Output_ptr );

}/* END OF CRYS_RSA_PRIM_Encrypt */

#endif /*!defined(_INTERNAL_CRYS_NO_RSA_ENCRYPT_SUPPORT) && !defined(_INTERNAL_CRYS_NO_RSA_VERIFY_SUPPORT)*/

#if !defined(_INTERNALCRYS_NO_RSA_DECRYPT_SUPPORT) && !defined(_INTERNAL_CRYS_NO_RSA_SIGN_SUPPORT)
/**
@brief
CRYS_RSA_PRIM_Decrypt implements the RSADP algorithm as defined in PKCS#1 v2.1 6.1.2

  @param[in] PrivKey_ptr - Pointer to the private key data
                           structure. \note The representation (pair
                           or quintiple) and hence the algorithm (CRT
                           or not) is determined by the Private Key
                           data structure. Using CRYS_Build_PrivKey or
                           CRYS_Build_PrivKeyCRT determines which
                           algorithm will be used.
                           
  @param[in] PrimeData_ptr - a pointer to a structure containing internal buffers
                             required for the RSA operation.                           
  @param[in] Data_ptr - Pointer to the data to be decrypted.
  @param[in] DataSize - The size, in bytes, of the data to
                        decrypt. \note Must be <= the size of the
                        modulus. 

  @param[out] Output_ptr - Pointer to the decrypted data, the buffer
                           must be at least PrivKey_ptr->N.len bytes
                           long (that is, the size of the modulus, in bytes).

  @return CRYSError_t - CRYS_OK,
                        CRYS_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
                        CRYS_RSA_PRIM_DATA_STRUCT_POINTER_INVALID,
                        CRYS_RSA_PRIV_KEY_VALIDATION_TAG_ERROR,
                        CRYS_RSA_DATA_POINTER_INVALID_ERROR,
                        CRYS_RSA_INVALID_OUTPUT_POINTER_ERROR,
                        CRYS_RSA_INVALID_MESSAGE_DATA_SIZE,
                        CRYS_RSA_INVALID_MESSAGE_VAL
 */

CEXPORT_C CRYSError_t CRYS_RSA_PRIM_Decrypt(CRYS_RSAUserPrivKey_t *UserPrivKey_ptr,
                                  CRYS_RSAPrimeData_t   *PrimeData_ptr,
                                  DxUint8_t               *Data_ptr,
                                  DxUint16_t               DataSize,
                                  DxUint8_t               *Output_ptr)
{				  
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PRIM_DEC_OP_CODE, 5,
	   							 /* PARAMETERS: */
								 UserPrivKey_ptr,
								 PrimeData_ptr,
								 Data_ptr, DataSize,
								 Output_ptr );

}/* END OF CRYS_RSA_PRIM_Decrypt */
#endif /*!defined(_INTERNAL_CRYS_NO_RSA_DECRYPT_SUPPORT) && !defined(_INTERNAL_CRYS_NO_RSA_SIGN_SUPPORT)*/


